<?php

use Phinx\Migration\AbstractMigration;

class AddInitialData extends AbstractMigration
{

    public function up()
    {
        $options = $this->table('options');

        $rows = array(
            array(
                'option_name'  => 'installed',
                'option_value' => '0'
            ),
            array(
                'option_name'  => 'app_version',
                'option_value' => APP_VERSION
            ),
            array(
                'option_name'  => 'salt',
                'option_value' => sha1(uniqid())
            ),
            array(
                'option_name'  => 'cipherSeed',
                'option_value' => mt_rand() . mt_rand() . mt_rand()
            ),
            array(
                'option_name'  => 'site_name',
                'option_value' => 'Mighty URL Shortener'
            ),
            array(
                'option_name'  => 'site_description',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'admin_email',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'default_public_plan',
                'option_value' => '1'
            ),
            array(
                'option_name'  => 'default_member_plan',
                'option_value' => '1'
            ),
            array(
                'option_name'  => 'site_maintenance',
                'option_value' => 'no'
            ),
            array(
                'option_name'  => 'site_api',
                'option_value' => 'yes'
            ),
            array(
                'option_name'  => 'blacklisted_domains',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'redirections',
                'option_value' => 'a:2:{i:0;s:1:"1";i:1;s:1:"2";}'
            ),
            array(
                'option_name'  => 'timer',
                'option_value' => '5'
            ),
            array(
                'option_name'  => 'reserved_aliases',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'reserved_usernames',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'google_analytics',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'recaptcha_siteKey',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'recaptcha_secretKey',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'cache_disable',
                'option_value' => '0'
            ),
            array(
                'option_name'  => 'site_language',
                'option_value' => 'eng'
            ),
            array(
                'option_name'  => 'api_usage_limit',
                'option_value' => '1000'
            ),
            array(
                'option_name'  => 'head_code',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'footer_code',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'after_body_tag_code',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'ads_area1',
                'option_value' => '<img src="https://placeholdit.imgix.net/~text?txtsize=23&bg=ffffff&txt=Ads%20Area%201&w=728&h=90" style="border: 1px solid #e7e7e7;">'
            ),
            array(
                'option_name'  => 'ads_area2',
                'option_value' => '<a href="http://www.siteground.com" onClick="this.href=\'https://www.siteground.com/web-hosting.htm?afbannercode=4c944fe976ad9faabc42605a7b112bc7\'" ><img src="https://ua.siteground.com/img/banners/general/best-pack/468x60.gif" alt="Web Hosting" width="468" height="60" border="0"></a>'
            ),
            array(
                'option_name'  => 'facebook_url',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'twitter_url',
                'option_value' => ''
            ),
            array(
                'option_name'  => 'googleplus_url',
                'option_value' => ''
            )
        );

        $options->insert($rows);
        $options->saveData();

        $table = $this->table('plans');

        $rows = array(
            'id'           => 1,
            'enable'       => 1,
            'title'        => 'Default',
            'redirections' => 'a:2:{i:0;s:1:"1";i:1;s:1:"2";}',
            'stats'        => 2,
            'api'          => 1,
            'timer'        => 1,
            'comments'     => 1,
            'sharing'      => 1,
            'feed'         => 1,
            'ads_area1'    => 1,
            'ads_area2'    => 1,
            'updated'      => date("Y-m-d H:i:s"),
            'created'      => date("Y-m-d H:i:s")
        );
        $table->insert($rows);
        $table->saveData();

        $table = $this->table('pages');

        $rows = array(
            array(
                'id'        => 1,
                'title'     => 'Terms of Use',
                'slug'      => 'terms',
                'published' => 1,
                'content'   => '',
                'updated'   => date("Y-m-d H:i:s"),
                'created'   => date("Y-m-d H:i:s")
            ),
            array(
                'id'        => 2,
                'title'     => 'Privacy Policy',
                'slug'      => 'privacy',
                'published' => 1,
                'content'   => '',
                'updated'   => date("Y-m-d H:i:s"),
                'created'   => date("Y-m-d H:i:s")
            ),
            array(
                'id'        => 3,
                'title'     => 'DMCA',
                'slug'      => 'dmca',
                'published' => 1,
                'content'   => '',
                'updated'   => date("Y-m-d H:i:s"),
                'created'   => date("Y-m-d H:i:s")
            )
        );
        $table->insert($rows);
        $table->saveData();

        $table = $this->table('users');

        $rows = array(
            'id'               => 1,
            'username'         => 'anonymous',
            'status'           => 'Active',
            'account_type'     => 'Free',
            'plan_id'          => 1,
            'password'         => '$2a$10$e3aJeB5KVHEj2F5N2ivqh.esXDapn9faVUrKECW62Q37vxSbSIUFa',
            'redirection_type' => 2,
            'country'          => 'US',
            'timer'            => 5,
            'updated'          => date("Y-m-d H:i:s"),
            'created'          => date("Y-m-d H:i:s")
        );
        $table->insert($rows);
        $table->saveData();
    }

    public function down()
    {
        $table_prefix = $table->getAdapter()->getOption('table_prefix');

        $table = $this->table('options');
        $this->execute('TRUNCATE ' . $table_prefix . 'options');

        $table = $this->table('plans');
        $this->execute('TRUNCATE ' . $table_prefix . 'plans');

        $table = $this->table('pages');
        $this->execute('TRUNCATE ' . $table_prefix . 'pages');
        
        $table = $this->table('users');
        $this->execute('TRUNCATE ' . $table_prefix . 'users');
    }
}
